# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new SharePoint site
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the new site
$webUrl = "http://sharepoint/newsite"

# Template name
$template = "CMSPUBLISHING#0"

# Site name
$name = "Publishing Site"

# Site description
$description = "A site about publishing."

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Create the site and add it to the quick launch and top navigation of the parent site
New-SPWeb -Url $webUrl -Template $template -Name $name -Description $description -AddToQuickLaunch -AddToTopNav -UniquePermissions

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 